﻿/*
VERSION:	1.0

DECRIPTION:
	This system is meant to be used with the  tileWalk.as  style of movement.
	It collides with tiles on the map.

AVAILABLE DATA:
	This returns a collision function which changes its parent's objects & properties.
	The parent collision system (this) contains:
		xOffset, yOffset
		player_mc
			_x, _y
		collision_array
		walk_obj
			xVel, yVel
	
*/
function makeTileCollision()
{
	var collision_funct = function()
	{
		// extract velocities
		var xVel = this.walk_obj.xVel;
		var yVel = this.walk_obj.yVel;
		
		// get player's current tile
		var xPlayer = Math.floor(this.player_mc._x / 16);
		var yPlayer = Math.floor(this.player_mc._y / 16);
		
		// get destination tile
		var xDest = xPlayer + xVel;
		var yDest = yPlayer + yVel;
		
		// store collision value
		var collision = this.collision_array[xDest][yDest];
		
		// if collision value is not 0
		if( collision != 0 )
		{
			// cancel all velocities
			this.walk_obj.xVel = 0;
			this.walk_obj.yVel = 0;
		}// if:  collision is imminent
	}// collision_funct()
	
	return collision_funct;
}// makeTileCollision()
